unit UPyramide;

interface

uses UQuader;

type TPyramide = object(TQuader)                // Pyramide erbt von Quader
        public
           function Volumen : extended;
           function Oberflaeche : extended;
     end;

implementation

function TPyramide.Volumen : extended;
begin
     result := (l*b*h)/3;
end;

function TPyramide.Oberflaeche : extended;
begin
     result := l*b+Sqrt(Sqr(l/2)+Sqr(h))*b+Sqrt(Sqr(b/2)+Sqr(h))*l;
end;

end.
